/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.ui.mainmenu;

import Krasnodar.rockstarnew.Rockstar;
import Krasnodar.rockstarnew.framework.base.UIContext;
import Krasnodar.rockstarnew.framework.objects.BorderRadius;
import Krasnodar.rockstarnew.systems.modules.modules.visuals.Interface;
import Krasnodar.rockstarnew.ui.mainmenu.IMenuButton;
import Krasnodar.rockstarnew.utility.animation.base.Animation;
import Krasnodar.rockstarnew.utility.animation.base.Easing;
import Krasnodar.rockstarnew.utility.colors.ColorRGBA;
import Krasnodar.rockstarnew.utility.game.cursor.CursorType;
import Krasnodar.rockstarnew.utility.game.cursor.CursorUtility;
import Krasnodar.rockstarnew.utility.render.obj.Rect;
import lombok.Generated;
import ru.kotopushka.compiler.sdk.annotations.Compile;

public class CustomButton
extends Rect
implements IMenuButton {
    private final String icon;
    private final float iconSize;
    private final Runnable onClick;
    private final ColorRGBA backgroundColor = new ColorRGBA(58.0f, 58.0f, 58.0f);
    private final Animation activeAnim = new Animation(400L, 0.0f, Easing.BAKEK);
    private final Animation hoverAnim = new Animation(300L, 0.0f, Easing.FIGMA_EASE_IN_OUT);

    @Override
    @Compile
    public void draw(UIContext context) {
        if (this.hovered(context.getMouseX(), context.getMouseY()) && this.activeAnim.getValue() == 1.0f) {
            CursorUtility.set(CursorType.HAND);
        }
        this.hoverAnim.update(this.hovered(context.getMouseX(), context.getMouseY()) && this.activeAnim.getValue() == 1.0f);
        float baseAlpha = Interface.showGlass() ? 0.7f : 0.33f;
        float hoverAlpha = Interface.showGlass() ? 0.3f : 0.2f;
        context.drawRoundedRect(this.x, this.y, this.width, this.height, BorderRadius.all(Math.min(this.width, this.height) / 2.0f), this.backgroundColor.withAlpha(255.0f * (baseAlpha * this.activeAnim.getValue() + hoverAlpha * this.hoverAnim.getValue())));
        context.drawTexture(Rockstar.id(this.icon), this.x + (this.width - this.iconSize) / 2.0f, this.y + (this.height - this.iconSize) / 2.0f, this.iconSize, this.iconSize, ColorRGBA.WHITE.withAlpha(255.0f * this.activeAnim.getValue()));
    }

    @Override
    @Compile
    public void click(double mouseX, double mouseY, int button) {
        if (this.hovered(mouseX, mouseY) && button == 0 && this.activeAnim.getValue() == 1.0f) {
            this.onClick.run();
        }
    }

    @Generated
    public CustomButton(String icon, float iconSize, Runnable onClick) {
        this.icon = icon;
        this.iconSize = iconSize;
        this.onClick = onClick;
    }

    @Override
    @Generated
    public Animation getActiveAnim() {
        return this.activeAnim;
    }
}

